/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.item;

import dev.ftb.extendedexchange.Star;
import dev.ftb.extendedexchange.item.ModItems;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.capability.EmcHolderItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.items.IBarHelper;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.integration.IntegrationHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public class MagnumStarItem
extends ItemPE
implements IItemEmcHolder,
IBarHelper {
    public final Star tier;

    public MagnumStarItem(Star tier) {
        super(new Item.Properties().m_41487_(1).m_41491_(ModItems.ItemGroups.CREATIVE_TAB));
        this.tier = tier;
        this.addItemCapability(EmcHolderItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return stack.m_41782_();
    }

    public float getWidthForBar(ItemStack stack) {
        long starEmc = this.getStoredEmc(stack);
        return (float)(starEmc == 0L ? 1.0 : 1.0 - (double)starEmc / (double)this.getMaximumEmc(stack));
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int m_142159_(@Nonnull ItemStack stack) {
        return this.getColorForBar(stack);
    }

    public long insertEmc(@Nonnull ItemStack stack, long toInsert, IEmcStorage.EmcAction action) {
        if (toInsert < 0L) {
            return this.extractEmc(stack, -toInsert, action);
        }
        long toAdd = Math.min(this.getNeededEmc(stack), toInsert);
        if (action.execute()) {
            MagnumStarItem.addEmcToStack((ItemStack)stack, (long)toAdd);
        }
        return toAdd;
    }

    public long extractEmc(@Nonnull ItemStack stack, long toExtract, IEmcStorage.EmcAction action) {
        if (toExtract < 0L) {
            return this.insertEmc(stack, -toExtract, action);
        }
        long storedEmc = this.getStoredEmc(stack);
        long toRemove = Math.min(storedEmc, toExtract);
        if (action.execute()) {
            MagnumStarItem.setEmc((ItemStack)stack, (long)(storedEmc - toRemove));
        }
        return toRemove;
    }

    public long getStoredEmc(@Nonnull ItemStack stack) {
        return MagnumStarItem.getEmc((ItemStack)stack);
    }

    public long getMaximumEmc(@Nonnull ItemStack stack) {
        return this.tier.getMaxEMC(false);
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.tier == Star.OMEGA ? Rarity.EPIC : super.m_41460_(stack);
    }
}

